CREATE TABLE IF NOT EXISTS file_metadata_entries (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    file_id VARCHAR(36) NOT NULL,
    metadata_id VARCHAR(36),
    value TEXT,
    created BIGINT,
    updated BIGINT
);

CREATE INDEX idx_file_metadata_entries_file_id ON file_metadata_entries (file_id);

CREATE INDEX idx_file_metadata_entries_metadata_id ON file_metadata_entries (metadata_id);

CREATE INDEX idx_file_metadata_entries_id ON file_metadata_entries (id);

-- Insert existing data from metadata_item table
INSERT INTO file_metadata_entries (
    id, file_id, metadata_id, value, created, 
    updated
) 
SELECT 
    metadata_item.id, 
    metadata_item.item_id, 
    metadata_item.metadata_id, 
    metadata_item.value, 
    metadata_item.created, 
    metadata_item.updated 
FROM 
    metadata_item,
    metadata 
WHERE 
    metadata.app="Files" 
    AND metadata.id=metadata_item.metadata_id;

-- Delete remaining data
DELETE FROM 
    metadata_item 
WHERE 
    metadata_id in (
        SELECT 
            metadata_id 
        FROM 
            metadata, 
            metadata_item 
        WHERE 
            metadata.app="Files" 
            AND metadata.id=metadata_item.metadata_id);

DELETE FROM 
    metadata
WHERE
    app="Files";
