CREATE TABLE IF NOT EXISTS activity (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    app VARCHAR(255) NOT NULL,
    type VARCHAR(255) NOT NULL,
    user_id VARCHAR(36) NOT NULL,
    affected_user VARCHAR(36) NOT NULL,
    item_id VARCHAR(36) NOT NULL,
    parent_id VARCHAR(36) NOT NULL,
    parameters LONGTEXT,
    created BIGINT(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_activity_parent ON activity (parent_id);

CREATE INDEX idx_activity_affected_user ON activity (affected_user);

CREATE INDEX idx_activity_item_id ON activity (item_id);

CREATE INDEX idx_activity_type ON activity (type);

CREATE INDEX idx_activity_user_id ON activity (user_id);