CREATE TABLE IF NOT EXISTS project_tasks (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    type VARCHAR(255) NOT NULL,
    parent_id VARCHAR(36),
    project_id VARCHAR(36) NOT NULL,
    title VARCHAR(255) NOT NULL,
    description VARCHAR(255),
    file_ids TEXT,
    depends VARCHAR(36),
    start_date VARCHAR(255),
    end_date VARCHAR(255),
    created_by VARCHAR(36) NOT NULL,
    assigned_to VARCHAR(36),
    status VARCHAR(255) NOT NULL,
    updated BIGINT(20) NOT NULL,
    created BIGINT(20) NOT NULL,
    trash TINYINT(1) DEFAULT 0 NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_project_tasks_project_id ON project_tasks (project_id);

CREATE INDEX idx_project_tasks_id ON project_tasks (id);

CREATE INDEX idx_project_tasks_created_by ON project_tasks (created_by);

CREATE INDEX idx_project_tasks_assigned_to ON project_tasks (assigned_to);