CREATE TABLE IF NOT EXISTS file_cache (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    owner VARCHAR(36) NOT NULL,
    parent VARCHAR(36) NOT NULL,
    storage VARCHAR(255) NOT NULL,
    path VARCHAR(255) NOT NULL,
    name VARCHAR(255) NOT NULL,
    displayname VARCHAR(255) NOT NULL,
    size BIGINT(20) NOT NULL,
    type VARCHAR(255) NOT NULL,
    is_folder TINYINT(1) NOT NULL,
    shared TINYINT(1) NOT NULL,
    created BIGINT(20) NOT NULL,
    modified BIGINT(20) NOT NULL,
    trash TINYINT(1) DEFAULT 0 NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_file_id ON file_cache (id);

CREATE INDEX idx_file_parent ON file_cache (parent);

CREATE INDEX idx_file_owner ON file_cache (owner);

CREATE INDEX idx_file_type ON file_cache (type);

CREATE INDEX idx_file_storage ON file_cache (storage);

