CREATE TABLE IF NOT EXISTS notifications (
    id VARCHAR(36) NOT NULL PRIMARY KEY UNIQUE,
    sender LONGTEXT NOT NULL,
    message VARCHAR(255),
    receiver VARCHAR(36) NOT NULL,
    app VARCHAR(255) NOT NULL,
    notification_type VARCHAR(255) NOT NULL,
    item_id VARCHAR(36) NOT NULL,
    is_read TINYINT(1) NOT NULL,
    is_sent TINYINT(1) NOT NULL,
    created BIGINT(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE INDEX idx_notifications_receiver ON notifications (receiver);

CREATE INDEX idx_notifications_sent ON notifications (is_sent);

CREATE INDEX idx_notifications_read ON notifications (is_read);